/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsenchantments.curses;

import com.majruszsenchantments.Registries;
import com.mlib.EquipmentSlots;
import com.mlib.config.ConfigGroup;
import com.mlib.config.DoubleConfig;
import com.mlib.config.IConfigurable;
import com.mlib.contexts.OnEnchantmentAvailabilityCheck;
import com.mlib.contexts.OnEntityTick;
import com.mlib.contexts.base.Condition;
import com.mlib.contexts.base.ModConfigs;
import com.mlib.enchantments.CustomEnchantment;
import com.mlib.levels.LevelHelper;
import com.mlib.math.Range;
import com.mlib.modhelper.AutoInstance;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraftforge.api.distmarker.Dist;

public class CorrosionCurse
extends CustomEnchantment {
    public CorrosionCurse() {
        this.rarity(Enchantment.Rarity.RARE).category(EnchantmentCategory.ARMOR).slots(EquipmentSlots.ARMOR).curse().minLevelCost(level -> 10).maxLevelCost(level -> 50);
    }

    @AutoInstance
    public static class Handler {
        final DoubleConfig damageAmount = new DoubleConfig(0.25, new Range((Number)0.0, (Number)10.0));
        final Supplier<CorrosionCurse> enchantment = Registries.CORROSION;

        public Handler() {
            ConfigGroup group = ModConfigs.registerSubgroup((String)Registries.Groups.CURSE).name("Corrosion").comment("Gradually destroys the item and inflicts damage to the owner when in water.");
            OnEnchantmentAvailabilityCheck.listen((Consumer)OnEnchantmentAvailabilityCheck.ENABLE).addCondition(OnEnchantmentAvailabilityCheck.is(this.enchantment)).addCondition(OnEnchantmentAvailabilityCheck.excludable()).insertTo(group);
            OnEntityTick.listen(this::damageOnContactWithWater).addCondition(Condition.isServer()).addCondition(Condition.hasEnchantment(this.enchantment, data -> data.entity)).addCondition(Condition.cooldown((double)3.0, (Dist)Dist.DEDICATED_SERVER)).addCondition(Condition.predicate(data -> LevelHelper.isRainingAt((Entity)data.entity) || data.entity.m_20069_())).addConfig((IConfigurable)this.damageAmount.name("damage_amount").comment("Damage dealt to the player every tick per each enchantment level.")).insertTo(group);
        }

        private void damageOnContactWithWater(OnEntityTick.Data data) {
            assert (data.entity != null);
            this.attackOwner(data.entity);
            this.damageArmor(data.entity);
        }

        private void attackOwner(LivingEntity entity) {
            float damage = this.damageAmount.asFloat();
            if (damage > 0.0f) {
                entity.m_6469_(DamageSource.f_19319_, damage * (float)this.enchantment.get().getEnchantmentSum(entity, EquipmentSlots.ARMOR));
            }
        }

        private void damageArmor(LivingEntity entity) {
            for (EquipmentSlot equipmentSlotType : EquipmentSlots.ARMOR) {
                ItemStack itemStack = entity.m_6844_(equipmentSlotType);
                if (!this.enchantment.get().hasEnchantment(itemStack)) continue;
                itemStack.m_41622_(1, entity, owner -> owner.m_21166_(equipmentSlotType));
            }
        }
    }
}

